//==========================================================================;
//
//  This material has been supplied as part of the Sonic Foundry Plug-In
//  Development Kit (PIDK). Under copyright laws, this material may not be
//  duplicated in whole or in part, except for personal use, without the
//  express written consent of Sonic Foundry, Inc. Refer to the license
//  agreement contained with the PIDK before using any part of this material.
//
//  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
//  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
//  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
//  PURPOSE.
//
//  Web:    www.sonicfoundry.com
//  Email:  pidk@sonicfoundry.com
//
//  Copyright (C) 1996-1998 Sonic Foundry, Inc. All Rights Reserved.
//  Portions Copyright (C) 1992-1996 Microsoft Corporation.
//
//--------------------------------------------------------------------------;
//
//  DirectX Media Streaming Services (formally known as ActiveMovie)
//  interfaces defined by Sonic Foundry, Inc. for use in developing DirectX
//  Audio Plug-Ins.
//
//==========================================================================;

#ifdef __cplusplus
extern "C"
{
#endif

//
//  IStaticFilterPreset GUID
//
//  {36A22460-0CC9-11D0-8574-00A0C9053912}
//
DEFINE_GUID(IID_IStaticFilterPreset,
            0x36A22460, 0xCC9, 0x11D0, 0x85, 0x74,
            0x00, 0xA0, 0xC9, 0x05, 0x39, 0x12);

// the rest of this need be included only once.
//
#ifndef __SFIFACE__
#define __SFIFACE__

//
//  This is a new format tag defined by Microsoft that is in new MMREG.H
//  header files.. but most people do not have the new MMREG.H yet, so we
//  redefine it here.
//
//  This new data type is for passing native 32-bit and 64-bit floats as
//  audio data. It is _highly_ recommended that all ActiveMovie audio
//  plug-ins support this format (at least for 32-bit floats) for maintaining
//  precision necessary for 24-bit capable applications.
//
//  This new data type is used like this (and should be written to .WAV
//  files with this 'fmt' header):
//  
//      LPWAVEFORMATEX pwfx;
//
//      pwfx->wFormatTag      = WAVE_FORMAT_IEEE_FLOAT;
//      pwfx->nChannels       = cChannels;
//      pwfx->nSamplesPerSec  = dwSampleRate;
//      pwfx->wBitsPerSample  = 32;
//      pwfx->nBlockAlign     = pwfx->nChannels * (pwfx->wBitsPerSample/8);
//      pwfx->nAvgBytesPerSec = pwfx->nBlockAlign *
//                              pwfx->nSamplesPerSec;
//      pwfx->cbSize          = 0;
//  
//  The above example is for floats. Doubles (perhaps overkill, but
//  possible) can be supported by setting wBitsPerSample to 64.
//  
//  Now the really important stuff:
//  
//    - The floats are _normalized_ -1.0 to 1.0
//    - Overdriven samples are valid and must be bounded by the playback
//      (renderer) device (normally an application transforms this data
//      on the fly to 8, 16, or 24 bit PCM before sending it to a wave
//      device).
//  
//  By doing this, 24 bits of precision can be maintained even with an
//  overdriven signal to +/-1.9999... You start losing precision after
//  that, but hopefully that's a result of the user applying too much gain.
//  If you have a chain of plug-ins, one plug-in can overdrive the signal
//  and the next plug-in may cause a gain reduction bringing it back to a
//  normal range. This is good.
//
#ifndef WAVE_FORMAT_IEEE_FLOAT
#define WAVE_FORMAT_IEEE_FLOAT 3
#endif

// forward reference interface declarations
//
typedef interface IStaticFilterPreset    IStaticFilterPreset;
typedef interface IAudioTransformMetrics IAudioTransformMetrics;

/*+
 *
 *  // IStaticFilterPreset. This interface exists so that an application can
 *  // get use presets defined statically in an ActiveMovie filter. (The term
 *  // preset refers to a collection of filter properties that have a
 *  // descriptive name).  This interface is for static presets only; that
 *  // is, presets defined when the filter is compiled. Dynamic presets are
 *  // managed using the IPersistStream interface.
 *
 *  //
 *  // This member returns the number of static presets that are available
 *  //
 *  STDMETHOD(GetPresetCount) (THIS_
 *      int * piCount     // [out] returns number of static presets
 *      ) PURE;
 *
 *  //
 *  // This member returns the name of a preset in the current language
 *  // the input 'index' identifies which preset to name
 *  //
 *  STDMETHOD(GetPresetName) (THIS_
 *      int      index,   // [in]  identifies which preset
 *      LPOLESTR pszName, // [out] preset name returned here
 *      DWORD    cchName  // [in]  size of output buffer in characters
 *      ) PURE;
 *
 *  //
 *  // This member causes the filter to begin using the preset indicated
 *  // by 'index' as its current property settings.
 *  //
 *  STDMETHOD(UsePreset) (THIS_
 *      int      index    // [in] identifies the preset to use
 *      ) PURE;
 *
 *-======================================================================*/


/*+
 *
 *  Sound Forge 4.0 Specific Note:
 *
 *  At least one initializer is required. Note that the first one is always 
 *  assumed to be the 'default' or 'untitled' preset. It is used when no other 
 *  preset is specified. By design, Sound Forge 4.0 will replace the first 
 *  initializer preset name with 'Untitled'.  
 *
 *-======================================================================*/

#if defined(__cplusplus) && !defined(CINTERFACE)
    
    interface IStaticFilterPreset : public IUnknown
    {
    public:
        virtual HRESULT __stdcall GetPresetCount (
            /* [out] */ long __RPC_FAR *piCount) = 0;
        
        virtual HRESULT __stdcall GetPresetName (
            /* [in] */  long     index,
            /* [out] */ LPOLESTR pszName,
            /* [in] */  DWORD    cchName) = 0;
        
        virtual HRESULT __stdcall UsePreset (
            /* [in] */  long     index) = 0;
    };
    
#else   /* C style interface */

    typedef struct IStaticFilterPresetVtbl
    {
        HRESULT ( __stdcall __RPC_FAR *QueryInterface )( 
            IStaticFilterPreset __RPC_FAR * This,
            /* [in] */ REFIID riid,
            /* [out] */ void __RPC_FAR *__RPC_FAR *ppvObject);
        
        ULONG ( __stdcall __RPC_FAR *AddRef )( 
            IStaticFilterPreset __RPC_FAR * This);
        
        ULONG ( __stdcall __RPC_FAR *Release )( 
            IStaticFilterPreset __RPC_FAR * This);
        
        HRESULT ( __stdcall __RPC_FAR *GetPresetCount )(
            IStaticFilterPreset __RPC_FAR * This,
            /* [out] */ long __RPC_FAR *piCount);
        
        HRESULT ( __stdcall __RPC_FAR *GetPresetName )(
            IStaticFilterPreset __RPC_FAR * This,
            /* [in] */  long     index,
            /* [out] */ LPOLESTR pszName,
            /* [in] */  DWORD    cchName);

        HRESULT ( __stdcall __RPC_FAR *UsePreset)(
            IStaticFilterPreset __RPC_FAR * This,
            /* [in] */  long     index);
        
    } IStaticFilterPresetVtbl;

    interface IStaticFilterPreset
    {
        CONST_VTBL struct IStaticFilterPresetVtbl __RPC_FAR *lpVtbl;
    };

#ifdef COBJMACROS

#define IStaticFilterPreset_QueryInterface(This,riid,ppvObject) \
    (This)->lpVtbl->QueryInterface(This,riid,ppvObject)

#define IStaticFilterPreset_AddRef(This) \
    (This)->lpVtbl->AddRef(This)

#define IStaticFilterPreset_Release(This) \
    (This)->lpVtbl->Release(This)


#define IStaticFilterPreset_GetPresetCount(This,piCount) \
    (This)->lpVtbl->GetPresetCount(This,piCount)

#define IStaticFilterPreset_GetPresetName(This,index,psz,cch) \
    (This)->lpVtbl->GetPresetName(This,index,psz,cch)

#define IStaticFilterPreset_UsePreset(This,index) \
    (This)->lpVtbl->UsePreset(This,index)

#endif /* COBJMACROS */

#endif  /* C style interface */

#endif // __SFIFACE__
#ifdef __cplusplus
} // extern "C"
#endif
